/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/**********************************
FILE var.h
contains the global varibles
*********************************/

/***************** GLOBAL VARIABLES **************/
#ifndef DEFINE_VARS
#define DEFINE_VARS

/**********************************
The circuit as read in
*********************************/

/******* size of circuit  **/
int maxlevel; 	/* maximum level in whole ckt */
int nogates;	/* #  gates */
int nolatches;	/* # Latches */
int nopin;	/* # primary inputs */
int nopout;	/* # primary output */
int nonodes;    /* total number of nodes */
int noart;      /* # artificial gates (used for dummy nodes  */

int maxid;	/* contains maximum of node ids; used  as array bound */
int maxfanin;   /* max of fanins over all circuit; just for stats */
int maxfanout; /* max of fanins over all circuitt; just for stats  */


/******* actual circuit  **/

NODETYPE *nodes[ MAX_NODES];	/* pointers to all nodes */
int validnode[ MAX_NODES];	/* not 0 if node is valid; nodes can be invalid when FF's are deleted */

/* these arrays have nodeids only;  actual nodes are in  nodes[id] */
int gates[MAX_GATES];	/* only gates */

Q *latches;	/* linked list for FFs*/
Q *top, *bot;
int primary_input[MAX_PIN];	/* array of primary inputs */
int primary_output[MAX_POUT];	/* array of primary oututs */
int artificial[MAX_POUT + MAX_PIN];	/* array of artificial gates */

int HOST;  /** node id of host vertex **/

/***** variables to get a free node when a FF is added **/

int freenodes[MAX_NODES]; /* contains the ids of nodes that are free (invalid) */
int nofreenodes;	/* contains the number of free ids */

/**** misc **/
int change;
float max_gate_delay;

int OBJ_VALUE;  /*** used for minarea LP */


/**********************************
Phase A constraint graph
*********************************/

VERT *verts;	/* array of vertices in S-graph*/
int node2vert[MAX_NODES];	/* gives id of vertex from id of FF */
int noverts;			/* # vertices */
int noedges;			/* # edge */

float Mindel,Maxdel,Max_self_loop;	/* min and max delay found in PERT 
					   Max_self is max delay in any
					   self loop and is used as lower bound
					   lower bound = max (mindel,self_loop_delay)*/

float PA_max_skew,PA_min_skew,PA_diff_skew;  /* to store stats on skew after phase A */



/**********************************
Variables to help in debugging
*********************************/

int pin_name; /* index of PI0 stored in nodenames used as id for
		 PIO vertex in graph */

int counter;	/* to return no of iterations taken in bell-ford */

char Node_Type[15][20]; /* to convert types in integer to string  */


FILE *fperr, *fpres, *fprest1, *fprest2 ;  /* various files for saving information */
char Ckt_Name[100];  /** name of the input circuit **/


#endif
