/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/**********************************
type.h
All typedef declarations
*********************************/

/*** elements for various linked lists **/
typedef struct f  /** linked lists of real numbers; used to store skews */
{
	float val;
	struct f *next;
} F;


typedef struct q  /** linked list of integers; used for queues */
{
	int el;
	struct q *next;
} Q;

typedef struct w /* for Wires in the circuit; used for fanins/fanouts of gates */
{
	int el;
	int wt;
	struct f *list;  /** skew values in a ordered linked list **/
	struct w *next;
} W;


/* all circuit elements Pin/Pout/Latches/Gates stored in this type */
typedef struct
{
	int id;	/* unique id to idenify node NOT used*/
	char name[MAX_NAME];
	int type;	/* type and/or/inv/dff/Pin/Pout */
	int nofin;	/* no of fanins */
	int nofout;	/* no of fanouts */
	float skew;	/* skew for FF*/
	float other_skew;	/* store other skew for FF */
	int phase;	/* phase of FF also used by simplex.c as a flag */
	float maxdel;	/* max gate delay */
	float mindel;	/* min gate delay NOT used  */
	float maxto;	/* max arrival time at OUTPUT */
	float minto;	/* max arrival time at INPUT */
	float maxti;	/* min arrival time at OUTPUT NOT used */
	float minti;	/* min arrival time at INPUT  NOT used */
	float rev_maxto; /** for PERT in reverse direction */
	float rev_maxti; /** for PERT in reverse direction */
	int nai;	/* # of active inputs in giving levels 
		   also used as a flag in PERT to indiacte gate is in
		   the queue;*/
	int nao;    /* # of active outputs; also used as flags */
	int level; /* level for PERT and used as a flag by simplex.c */

	int bounds[2];/* upper and lower bounds on gates */
	int IsFixed;  /* immobile gates, i.e, bounds[0] == bounds[1] */
	W *fin;	/* fanin list */
	W *fout;	/* fanout list */

	int Id_m,Ism,Lm,Um,Xm,Maxm; /*** added for mirror vertex 
				      Id_m = id of S_node of the mirror
				      Ism = 1 if mirror needed
				      Lm/Um/Xm Lower/Upper/value of Mirror r(v)
				      Maxm = max of m ***/
	 

} NODETYPE;

/* Edges in the constraint graph for Phase A*/
typedef struct ed
{
	float delay;	/* original delay d(ij)*/
	float weight;  /* weight after correction for specific period */
	int tovert;	/* sink vertex of this edge */
	struct ed *next;	/* pointer to next edge */
} EDGE;

/* Vertices in the constraint graph for Phase A*/

typedef struct vt
{
	int nodeid;	/* id of node, ie, nodes[nodeid] gives the corresponding FF*/
	float skew;  /** skew of FF; this is what is updated in Bellman-Ford */
	float asap,alap;  /** to store ASAP and ALAP skews **/
	EDGE *edges[2]; /* edges[0] has forward edges (fanin to fanout); edges[1] has reverse (fanout to fanin)*/
} VERT;


/*************** hashing types ***/
/* This is the base structure that holds a pins name, key, and number */
struct pn
{
	char name[MAX_NAME];
	int key;     /* Keep this so I don't have to recalc it each time. */
	int num;
	int IsPiPo;  /*  Flag for pi's and po's. */
	struct pn *nx;
};

/* A node in the hash table that contains eight pins and an overflow ptr */
struct hashnode {
	struct pn *p;
	int pins;
};

/******** just a pair of int and float used in heap **/
typedef struct
{
	int id;
	float value;
} INT_FLT;

/** to return the LP/Nw problem size for minarea ***/
typedef struct
{
	int no_var;
	int no_con;
} P_SIZE;

/**************************************************
network simplex data types 
**************************************************/

typedef struct arc_type  /** stores the arcs or constraints on the LP */
{
	int to;
	int from;
	int cost;
	int red_cost;  /* reduced cost */

} S_ARC;

typedef struct node_type  /** stores the nodes or variables of the LP */
{
	int ckt_id;  /* gives the corresponding gate in the circuit */
	int supply;  /* RHS of flow conservation constraints; also the coefficient of r(v) in the objective of minarea LP */
	int parent;  /* parent in the spanning tree */
	int level;   /* used for spanning tree */
	int dual;    /* value of dual variables; this will be r(v) in LP */
	int flow;    /* amount of flow */
	int orient;  /* direction of flow */
	int nochild; /* # of children in spanning tree */
	Q *child;    /* linked list of children in the spanning tree */
} S_NODE;


/**************************************************
data types for converting circuit to graph
**************************************************/

typedef struct save_latch
{
	int to;
	int from;
	int wt;
	F *skews[2];  /* store both ASAP and ALAP skews */
} SAVE_LATCH;
