/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/*******************************
FILE slack.c

to get forward and backward slacks by PERT
(this pert is different from "all_pert" which
calculates all-pair input-output delays.
******************************/

#include "include.h"
#define EPS 0.01


/*******************************
GLOBAL VARS
******************************/
extern int db_slack;
int maxdel_latch;

/*********************************************
 float forwardpert(int mode)

To get teh slack at fanins 
 run (normal/standard) pert with skews taken into account,
i.e., deprature and arrival times at latches are their skews.
Returns maxdel (which is the clock period also)
if (mode > 0) skews taken into account
else, all skews taken as zero
   *****************************************/
float forwardpert(int mode)
{
  int lno,n,n1;
  Q   *q1;
  W  *w1;
  NODETYPE *np, *np1;
  float max_delay;
  max_delay = -INF;
  top = bot = NULL;
  /* init level & nai */
  db_slack = 1;
  /* put all inputs in Q 
     init maxti of allgates may be redundant as already done in pert */
  for(lno=0;lno<nogates;lno++)
    { 
      n = gates[lno];
      nodes[n]->maxti = -INF;
      nodes[n]->maxto = -INF;
      nodes[n]->nai = 0;
    }
  for(lno=0;lno<nopin;lno++)
    { 
      n = primary_input[lno];
      np = nodes[n];
      np->maxti = 0;
      np->maxto = 0;
      addq(n);
    }
  /* init level & nai */
  for(q1=latches;q1 != NULL;q1 = q1->next)
    {
      n = q1->el;
      np = nodes[n];
      np->maxti = -INF;
      if(mode)np->maxto =  np->skew;
      else np->maxto = 0;

      addq(n);
    }
  /* process whole Q */
  while(top != NULL)
    {
      /* n,np node on top of Q */
      n = top->el;
      np = nodes[n];
      /* Don't want to update maxto from maxti rather use maxto directly**/
      if(np->type != Latch)np->maxto = np->maxti + np->maxdel;
      for(w1 = np->fout; w1 != NULL; w1= w1->next)
	{ /* process fanouts of current node n */
	  n1 = w1->el;
	  np1 = nodes[n1];
	  if( np1->maxti < np->maxto)
	    {  
	      np1->maxti = np->maxto;
	    }


	  if(np1->type == Latch) /* if fanout is latch do nothing else */
	    {
	      if(mode){
		if( max_delay <(np->maxto - np1->skew) ){
		  max_delay =(np->maxto - np1->skew);
		  maxdel_latch = n1;
		}
#ifdef DEBUG
		if(db_slack)printf("with skew  n1 %d maxto %g maxdel %g\n",n1,(np->maxto - np1->skew),max_delay);
#endif
		maxdel_latch = n1;
	      }
	      else {
		if( max_delay < np->maxto ){
		  max_delay = np->maxto;
		  maxdel_latch = n1;
		}
#ifdef DEBUG
		if(db_slack)printf(" n1 %d maxto %g maxdel %g\n",n1,np->maxto,max_delay);
#endif

	      }
	    }
	  else if(np1->type ==Pout)
	    {
	      if(max_delay < np->maxto ){
		max_delay = np->maxto;
		maxdel_latch = n1;
	      }
#ifdef DEBUG
	      if(db_slack)printf("PIO n1 %d maxto %g maxdel %g\n",n1,np->maxto,max_delay);
#endif

	    }
	  else
	    {
	      if(++np1->nai == np1->nofin)addq(n1);
	      /* all inputs active so add to Q */
	    }
	}
      /* np->nai = 0; reset nai to 0 */

      removeq();
    }/* while Q not empty */
  return(max_delay);

}

/*******************************************
float reversepert(int mode)

same as forwrdpert, but traversal is fanout to fanin
gives the slack at fanouts
********************************************/
float reversepert(int mode)
{
  int lno,n,n1;
  Q    *q1;
  W  *w1;
  NODETYPE *np, *np1;
  float max_delay;
  max_delay = -INF;
  top = bot = NULL;

  /* put all inputs in Q 
     init rev_maxti of allgates may be redundant as already done in  pert */

  for(lno=0;lno<nogates;lno++)
    { 
      n = gates[lno];
      nodes[n]->rev_maxti = -INF;
      nodes[n]->rev_maxto = -INF;
      nodes[n]->nao = 0;
    }
  for(lno=0;lno<nopout;lno++)
    { 
      n = primary_output[lno];
      np = nodes[n];
      np->rev_maxti = 0;
      np->rev_maxto = 0;
      addq(n);
    }

  for(q1=latches;q1 != NULL;q1 = q1->next)
    {
      n = q1->el;
      np = nodes[n];
      np->rev_maxti = -INF;

      if(mode)np->rev_maxto =  -1*np->skew;
      else np->rev_maxto = 0;
      addq(n);

      /*****************
	n1 = (np->fin)->el;
	np1 = nodes[n1];
	if(mode)
	{np->rev_maxto = -1*np->skew;
	if(np1->rev_maxti < -1*np->skew)np1->rev_maxti = -1*np->skew;
	}
	else{np->rev_maxto = 0;
	if(np1->rev_maxti < 0)np1->rev_maxti = 0;
	}
	      
	if(++np1->nao == np1->nofout)addq(n1);
	**************/
    }
  /* initilize "level" & "nai" */
  /* process whole queue */
  while(top != NULL)
    {
      /* get one element from the queue */
      n = top->el;
      np = nodes[n];

      if(np->type != Latch)np->rev_maxto = np->rev_maxti + np->maxdel;
      for(w1 = np->fin; w1 != NULL; w1= w1->next)
	{ /* process fanins of current node "n" */
	  n1 = w1->el;
	  np1 = nodes[n1];
	  if( np1->rev_maxti < np->rev_maxto)
	    {  
	      np1->rev_maxti = np->rev_maxto;
	    }

	  if(np1->type == Latch) /* if fanout is latch do nothing else */
	    {
	      if(mode){
		if( max_delay <(np->rev_maxto + np1->skew) ){
		  max_delay =(np->rev_maxto + np1->skew);
		  maxdel_latch = n1;
		}
#ifdef DEBUG
		if(0)printf("with skew n[%d]%s  n1 [%d]%s rev_maxto %g maxdel %g\n",n,nodes[n]->name,n1,nodes[n1]->name,(np->rev_maxto + np1->skew),max_delay);
#endif	
		maxdel_latch = n1;
	      }
	      else {
		if( max_delay < np->rev_maxto ){
		  max_delay = np->rev_maxto;
		  maxdel_latch = n1;
		}
#ifdef DEBUG
		if(0)printf("n[%d]%s  n1 [%d]%s rev_maxto %g maxdel %g\n",n,nodes[n]->name,n1,nodes[n1]->name,np->rev_maxto,max_delay);
#endif	
	      }
	    }
	  else if(np1->type ==Pin)
	    {
	      if(max_delay < np->rev_maxto ){
		max_delay = np->rev_maxto;
		maxdel_latch = n1;
	      }
#ifdef DEBUG
	      if(0)printf("PIN n[%d]%s  n1 [%d]%s  rev_maxto %g maxdel %g\n",n,nodes[n]->name,n1,nodes[n1]->name,np->rev_maxto,max_delay);
#endif	

	    }
	  else
	    {

	      if(++np1->nao == np1->nofout)addq(n1);
	      /* all inputs active so add to Q */
	    }
	}
      np->nao = 0;

      removeq();
    }/* while Q not empty */

  return(max_delay);

}



/***************************
NOT IN USE
void store_slacks_at_inputs()
{
int i;
int n,n1;
NODETYPE *np, *np1;
W *w1;
float time_in;

 
for(i=0;i<nogates;i++)
  {
    n = gates[i];
    np = nodes[n];
    time_in = np->maxti;
    for(w1 = np->fin; w1 != NULL; w1 = w1->next)
      {
	n1 = w1->el;
	np1 = nodes[n1];
	w1->wt = time_in - np1->maxto;
printf(" slack = %g\n",w1->wt);
      }
  }
}*******************/

/****************************************************************
use_slacks(float period)

This is needed only if we want to reduce redundant skews.
(no real reason, since the skew is redundant anyway)
trying to reduce skews of latches which have skew > delay/2 
(but these skews will be redundant due to slack)

If more than one latch are in series then until
the skew of 1st ff is not set that of next can't be set,
so need to repeat the procedue  as many times as needed
**************************************/

      int use_slacks(float period)
{
  int n,n1,latches_still_left=0;
  NODETYPE *np;
  Q *q1;
  float asap,alap,newskew,period1,period2; /* asap/alap are min, max bound on skews */
  float posdelay,negdelay;

  period1 = forwardpert(1);
  period2 = reversepert(1);

#ifdef DEBUG
  if(db_slack)printf("Periods before slacking F %g R %g\n",period1,period2);
#endif


  for(q1=latches;q1 != NULL;q1 = q1->next)
    {
      n = q1->el;
      np = nodes[n];
      asap = np->maxti - period;
      alap = period - np->rev_maxti;
      newskew = np->skew;
      n1 = (np->fin)->el;
      while(nodes[n1]->type == Latch)n1 = (nodes[n1]->fin)->el;
      posdelay = nodes[n1]->maxdel;
      posdelay = posdelay/2;

      n1 = (np->fout)->el;
      while(nodes[n1]->type == Latch)n1 = (nodes[n1]->fout)->el;
      negdelay = nodes[n1]->maxdel;
      negdelay = negdelay/2;

#ifdef DEBUG
      if(db_slack)printf(" Latch [%d]%s asap %g alap %g skew %g Ftime %g Rtime %g\n",n,nodes[n]->name,asap,alap,newskew,np->maxti,np->rev_maxti);
      if(db_slack)printf("init done \n");
#endif


      if(!((newskew <= alap +EPS )&&(newskew >= asap - EPS))){
	printf("\n ERROR \n************\n Skew out of bound  Latch [%d]%s asap %g alap %g skew %g Ftime %g Rtime %g\n\n",
	       n,nodes[n]->name,asap,alap,newskew,np->maxti,np->rev_maxti);
	print_ckt();
	exit(0);
      }

      if(newskew <0) /* increase if possible but not more than 0*/
	{
	  newskew = alap;
	  if(newskew >0)newskew = 0;
	}
      if(newskew > 0) /* decrease if possible but not more than 0*/
	{
	  newskew = asap;
	  if(newskew  < 0)newskew = 0;
	}
      np->skew = newskew;
      if( (newskew > (posdelay + EPS))||(newskew < -1*(negdelay+EPS))) {
	latches_still_left++;
	printf(" left %d latch [%d]%s skew %g  P %g N %g \n",latches_still_left,n,nodes[n]->name,newskew,posdelay,negdelay); 
      }

    }/* for all latches */
  return(latches_still_left);
}


/************** EOF *********************/
