/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/*******************************
FILE retime.c
******************************/
#include "include.h"
#include<stdlib.h>


/*******************************
GLOBAL VARS
******************************/
float P_bound;
float M_index;
int Max_UL;
int No_node;
int Move[1000]; /* # gates with U-L == index */


/*******************************
apply_retiming();
just apply the r(v) values stored in np->phase
to get wr(ij) = w(ij) + r(j) -r(i)
******************************/

void apply_retiming()
{
  NODETYPE *np, *np1;
  int n,i;
  W *w1;

	
  for(i=0;i<nogates ;i++)
    {
      n = gates[i];
      np = nodes[n];
      for(w1 = np->fout;w1 != NULL;w1 = w1->next)
	{
	  np1=nodes[w1->el];
	  w1->wt = w1->wt - np->phase + np1->phase;
	}
      for(w1 = np->fin;w1 != NULL;w1 = w1->next)
	{
	  np1=nodes[w1->el];
	  w1->wt = w1->wt - np1->phase + np->phase;
	}
    }

  for(i=0;i<nopin;i++)
    {
      n =primary_input[i];
      np = nodes[n];
      for(w1 = np->fout;w1 != NULL;w1 = w1->next)
	{
	  np1=nodes[w1->el];
	  w1->wt = w1->wt + np1->phase;
	}
    }
  for(i=0;i<nopout;i++)
    {
      n =primary_output[i];
      np = nodes[n];
      for(w1 = np->fin;w1 != NULL;w1 = w1->next)
	{
	  np1=nodes[w1->el];
	  w1->wt = w1->wt - np1->phase ;
	}
    }
}


/*******************************
count_latches_in_graph
IMPORTANT nogates should include HOST for correct answer

counts # latches in the graph
******************************/
int count_latches_in_graph()
{
  NODETYPE *np, *np1;
  int n,i,max,count,total;
  W *w1;

	
  count = 0;
  for(i=0;i<nopin;i++)
    {
      n =primary_input[i];
      np = nodes[n];
      max = 0;
      total =0;
      for(w1 = np->fout;w1 != NULL;w1 = w1->next)
	{
	  if(max < w1->wt)max = w1->wt; 
	}
      count += max;
    }

  /* all gates **/
  for(i=0;i<nogates ;i++)
    {
      n = gates[i];
      np = nodes[n];
      max = 0;
      total =0;
      for(w1 = np->fout;w1 != NULL;w1 = w1->next)
	{
	  if(max < w1->wt)max = w1->wt; 
	}
      count += max;
    }
  return(count);
}
/********************************************
NOT in use
how to handle PIO?
do not want to count PIO, so need to uncount any latch to PO
*******************************************/
int count_cuts_in_graph()
{
  NODETYPE *np, *np1;
  int n,i,max,count;
  W *w1;
	
  count = 0;
  for(i=0;i<nogates ;i++)
    {
      n = gates[i];
      if(n == HOST) continue;
      np = nodes[n];
      if(np->type == Pin || np->type == Pout || np->type == ARTIFICIAL) continue;
      max = 0;
      for(w1 = np->fout;w1 != NULL;w1 = w1->next)
	{
	  if(nodes[w1->el]->type != Pout)if(w1->wt > 0)max = 1; 
	}
      if(max)count++;
    }
	
  return (count);
}
/****************************************************

NOT IN USE

to add artficial gates at PIN with > 1 fanout
will work ONLY in a C-graph

**************************************************/
int add_art_at_input()
{
  NODETYPE *np, *np1;
  int n,n1,i,to_add,done,count;
  char name[100];
  W *w1, *w2;

  count = 0;

  for(i=0;i<nopin;i++)
    {
      n =primary_input[i];
      np = nodes[n];
      if(np->nofout >1)
	{
	  count++; /* no gates added */
	  to_add = maxid++;
	  gates[nogates++] = to_add;
	  strcpy(name,np->name);
	  strcat(name,"_ART");
	  init_node(to_add,name);
	  np1 = nodes[to_add];
	  np1->maxdel = 0;
	  np1->mindel = 0;
	  np1->type = ARTIFICIAL;

	  /* add pin to fanin of NEW */
	  np1->fin =  (W *)MALLOC(1,sizeof(W));
	  np1->fin->el = n;
	  np1->fin->wt = 0;
	  np1->fin->next = NULL;
	  np1->fin->list = NULL;
	  np1->nofin = 1;
	  /* get fanouts of NEW */
	  np1->fout = np->fout;
	  np1->nofout = np->nofout;

	  /* put NEW in fanout of PIN */
	  np->fout =  (W *)MALLOC(1,sizeof(W));
	  np->fout->el = to_add;
	  np->fout->wt = 0;
	  np->fout->next = NULL;
	  np->fout->list = NULL;
	  np->nofout = 1;

	  /* update fanin of Original fanouts of PIN */
	  for(w1= np1->fout;w1 != NULL; w1= w1->next)
	    {
	      done = 0;
	      for(w2= nodes[w1->el]->fout;w2 != NULL; w2= w2->next)
		{
		  if(w2->el == n)
		    {
		      w2->el = to_add; /* don't change wt */
		      done = 1;
		      break;
		      /**** !!!! change only one or all */
		    }
		}
	      if(!done) {
		printf("\n ERR{add_ART} did not find PIN[%d]%s in IN of [%d]%s\n",n,np->name,w1->el,nodes[w1->el]->name);
		exit(-1);
	      }
	    }


	} /* fout > 1 */
    }
  return(count);
}

/********************************
NOT IN USE
***********************************/
void print_2_cycles()
{
  int i,j,k,v1,v2,found;
  EDGE *e1,*e2;
  float delay;

  for(i=1;i<noverts;i++)
    {
      found = 0;
      for(e1= verts[i].edges[FORWARD];e1!=NULL;e1= e1->next)
	{
	  v1= e1->tovert;
	  for(e2= verts[v1].edges[FORWARD];e2!=NULL;e2= e2->next)
	    {
	      delay = e1->delay + e2->delay;
	      if(e2->tovert == i)
		if(delay > 56){
		  printf(" cycle vert [%d]%s to [%d]%s delay %.1f + %.1f \n",i,nodes[verts[i].nodeid]->name,
			 v1,nodes[verts[v1].nodeid]->name,e1->delay,e2->delay);
		  found =1;
		  break;
		}
	    }
	  if(found) break;
	}
    }
}

/********************************
NOT IN USE
***********************************/

int add_latches_in_cycles()
{
  int i,j,k,v1,v2,found;
  EDGE *e1,*e2;
  float delay;
  int fin,self,added,new;
  char name[100];

  added =0;
  for(i=1;i<noverts;i++)
    {
      found = 0;
      for(e1= verts[i].edges[FORWARD];e1!=NULL;e1= e1->next)
	{
	  v1= e1->tovert;
	  if(v1 == i){
	    if(e1->delay > 25)found = 1;
	  }
	  else
	    for(e2= verts[v1].edges[FORWARD];e2!=NULL;e2= e2->next)
	      {
		delay = e1->delay + e2->delay;
		delay = delay/2;
		if(e2->tovert == i)
		  if(delay > 25){
		    printf(" cycle vert [%d]%s to [%d]%s delay %.1f + %.1f \n",i,nodes[verts[i].nodeid]->name,v1,nodes[verts[v1].nodeid]->name,e1->delay,e2->delay);
		    found =1;
		    break;
		  }
	      }
	  if(found) break;
	}
      if(found){
	self = verts[i].nodeid;
	fin = nodes[self]->fin->el;
	sprintf(name,"EXTRA_%d",added++);
	new = add_latch(fin,self,0,name);
	printf(" addded latch %s id %d between %d & %d \n",name,new,fin,self);
      }
    }
  reset_ckt();
  return(added);
}

/******************************************
Generate stats on the mobility of gates/FF for Minaret

NEEDS TO BE CALLED even if stats not needed;
Mavg to be only over gates
*******************************************/
void store_moves()
{
  int i,m,n,max =0,mobility = 0,count=0,move,mirror=0,varm=0,varg=0;
  float pt,pg,pm;
  /** count no of gates  ; mirror no of mirrors; varm no of var mirrors **/
  NODETYPE *np;

  for(i=0;i<1000;i++)Move[i] = 0;
  for(i=0;i<(nogates-1);i++) /* do not inc host */
    {
      n= gates[i];
      np = nodes[n];
      move = np->bounds[UPPER] - np->bounds[LOWER];
	
      if(move <0){printf("ERR gate [%d]%s has U %d L %d \n",n,np->name,np->bounds[UPPER], np->bounds[LOWER]);exit(-1);}
      if(move >999)move = 999;
      if(move > max)max = move;
      Move[move]++;
      count++;
#ifdef DEBUG
      if(1)printf("High move gate [%d]%s has U %d L %d \n",n,np->name,np->bounds[UPPER], np->bounds[LOWER]);
#endif
      if(np->Ism == 1)
	{
	  move = np->Um - np->Lm;
	  if(move <0){printf("ERR MIRROR gate [%d]%s has U %d L %d \n",n,np->name,np->Um,np->Lm); exit(-1);}
	  mirror++;
	  if(move > 0)varm++;
#ifdef DEBUG
	  if(1)printf("High move MIRROR [%d]%s has U %d L %d \n",n,np->name,np->Um,np->Lm);
#endif
	}

    }
  Max_UL = max;

  for(i=0;i<=max;i++){
    mobility += i*Move[i];
    if(0)printf(" Mobility %d gates %d Per %.1f \n",i,Move[i],(100*(float)Move[i]/count));
  }

  P_bound = (100*(float)Move[0]/count);
  M_index = ((float)mobility/count);
  No_node = count+ mirror +1;  /* for host */
  varg = count - Move[0];
  pt = 100*(float)(varg + varm)/(count + mirror);
  pg = 100*(float)(varg)/(count);
  pm = 100*(float)(varm)/(mirror);

  /****** print the stats on the mobility **/	
  printf(" Percentage of gates that are fixed/immobile is %.2f \n Average mobility is %.3f \n (#Variables/#Nodes) Total %d/%d = %.2f; Gates %d/%d = %.2f;  Mirror %d/%d = %.2f  \n",P_bound, M_index,(varg + varm),(count + mirror), pt,varg,count,pg,varm,mirror,pm);

  fprintf(fpres," Pb %.2f Mavg %.3f (var/node) Total %d/%d = %.2f Gates %d/%d = %.2f Mirror %d/%d = %.2f \n",P_bound, M_index,(varg + varm),(count + mirror), pt,varg,count,pg,varm,mirror,pm);
	
	
	
}


/****************************************************
checks to see if any gate has > 1 FF at its fanout which can be merged
**************************************************/
void check_merging_of_latches()
{
  NODETYPE *np, *np1;
  int n,i,max,count,total;
  W *w1;

	
  for(i=0;i<nogates ;i++)
    {
      count = 0;
      n = gates[i];
      np = nodes[n];
      for(w1 = np->fout;w1 != NULL;w1 = w1->next)
	{
	  if(nodes[w1->wt]->type == Latch)count++;
	}
      if(count > 1){
	printf("$$$$ ERR gate [%d]%s has multiple ie %d latches\n",n,np->name,count);
	exit(-1);
      }
    }
}

/**************** EOF *************/
