/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/*******************************
FILE io.c
functions to write netlist
******************************/
#include "include.h"

#include<stdlib.h>



/*******************************************
 write_netlist(FILE *fpw)

should call remove_artifical before this function
if "ARTIF" gates are used in minarea.

will write netlist in the modified MCNC benchmark format
will also write delay values
***************************************/

void write_netlist(FILE *fpw)
{
  int i;
  NODETYPE *np1;
  Q *q1;
  W *w1;
  int t1,fan;
  int w_pi=0,w_po=0,w_dff=0,w_gate=0;

  for(i=0;i<nopin;i++)if(validnode[primary_input[i]]){
    fprintf(fpw,"INPUT  %s\n",nodes[primary_input[i]]->name);
    w_pi++;
  }
  fprintf(fpw,"\n");
  for(i=0;i<nopout;i++)
    {
      fan = (nodes[primary_output[i]]->fin)->el;
      fprintf(fpw,"OUTPUT  %s\n",nodes[fan]->name);
      w_po++;
    }
  fprintf(fpw,"\n");


  for(q1= latches;q1 != NULL;q1= q1->next)
    {
      t1 = q1->el;

      if(validnode[t1])
	{
	  np1 = nodes[t1];
	  fan = (np1->fin)->el;
	  fprintf(fpw,"%s   DFF   %s \n",nodes[t1]->name,nodes[fan]->name);
	  w_dff++;
	}

    }

  fprintf(fpw,"\n");
  for(i=0;i<nogates;i++)
    {
      t1 = gates[i];
      if(validnode[t1])
	{
	  np1 = nodes[t1];
	  fprintf(fpw,"%s  @%f  %s ",nodes[t1]->name,np1->maxdel,Node_Type[np1->type]);
	  w_gate++;

	  w1 = np1->fin;
	  while(w1 != NULL)
	    {
	      fprintf(fpw,"%s   ",nodes[w1->el]->name);
	      w1 = w1->next;
	    }
	  fprintf(fpw,"\n");

	}

    }
  fclose(fpw);
  printf(" WROTE PI %d PO %d DFF %d GATES %d \n",w_pi,w_po,w_dff,w_gate);
}

/*******************************************
write_benchmark(FILE *fpw)

should call remove_artifical before this function
if ARTIF gates are used in minarea

will write in the real MCNC format, will 
ignore gate delay

***************************************/

void write_benchmark(FILE *fpw)
{
  int i;
  NODETYPE *np1;
  Q *q1;
  W *w1;
  int t1,fan;
  int w_pi=0,w_po=0,w_dff=0,w_gate=0;
  int count[20];
  int act_gates;

  for(i=0;i<20;i++)count[i]=0;
  for(i=0;i<maxid;i++)if(validnode[i])count[nodes[i]->type]++;

  fprintf(fpw,"# %d inputs \n# %d outputs \n",nopin,nopout);
  fprintf(fpw,"# %d D-type flipflops \n",count[Latch]);
  fprintf(fpw,"# %d inverters \n",count[Not]);
  act_gates = count[And] + count[Nand] + count[Or] + count[Nor];
  fprintf(fpw,"# %d gates (",act_gates);
  if(count[And] >0)fprintf(fpw,"%d ANDs ",count[And]);
  if(count[Nand] >0)fprintf(fpw,"+ %d NANDs ",count[Nand]);
  if(count[Or] >0)fprintf(fpw,"+ %d ORs ",count[Or]);
  if(count[Nor] >0)fprintf(fpw,"+ %d NORs ",count[Nor]);
  fprintf(fpw,") \n\n");

  for(i=0;i<nopin;i++)if(validnode[primary_input[i]]){
    fprintf(fpw,"INPUT(%s)\n",nodes[primary_input[i]]->name);
    w_pi++;
  }
  fprintf(fpw,"\n");
  for(i=0;i<nopout;i++)
    {
      fan = (nodes[primary_output[i]]->fin)->el;
      fprintf(fpw,"OUTPUT(%s)\n",nodes[fan]->name);
      w_po++;
    }
  fprintf(fpw,"\n");


  for(q1= latches;q1 != NULL;q1= q1->next)
    {
      t1 = q1->el;

      if(validnode[t1])
	{
	  np1 = nodes[t1];
	  fan = (np1->fin)->el;
	  fprintf(fpw,"%s = DFF(%s)\n",nodes[t1]->name,nodes[fan]->name);
	  w_dff++;
	}

    }

  fprintf(fpw,"\n");
  for(i=0;i<nogates;i++)
    {
      t1 = gates[i];
      if(validnode[t1])
	{
	  np1 = nodes[t1];
	  fprintf(fpw,"%s = %s(",nodes[t1]->name,Node_Type[np1->type]);
	  w_gate++;

	  w1 = np1->fin;
	  fprintf(fpw,"%s",nodes[w1->el]->name);
	  w1 = w1->next;

	  while(w1 != NULL)
	    {
	      fprintf(fpw,", %s",nodes[w1->el]->name);
	      w1 = w1->next;
	    }
	  fprintf(fpw,")\n");

	}

    }
  fclose(fpw);
  printf(" WROTE PI %d PO %d DFF %d GATES %d \n",w_pi,w_po,w_dff,w_gate);
}



/*****************************************
write_latches(FILE *fpw)
Just write the FF's in a file, for debugging only

***********************************/

void write_latches(FILE *fpw)
{
  NODETYPE *np1;
  Q *q1;
  W *w1;
  int t1;



  for(q1= latches;q1 != NULL;q1= q1->next)
    {
      t1 = q1->el;
      if(validnode[t1])
	{
	  np1 = nodes[t1];
	  w1 = np1->fin;
	  fprintf(fpw,"%d %s\n",w1->el,Node_Type[nodes[w1->el]->type]);

	}
    }
  fclose(fpw);
}


/*********EOF**********/
