/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/**********************************
declare.h
contains all constant declarations
*********************************/

/**********************************
IMPORTANT maximum array sizes set here;
may require changes to handle larger circuits or to run on 
machines with less RAM
*********************************/

#define MAX_NAME 50
#define MAX_GATES	70000
#define  MAX_NODES      100000  /*MAX_GATES + MAX_LATCHES + MAX_PIN + MAX_POUT */
#define MAX_PIN	 700
#define MAX_POUT	 750
#define MAX_LEVELS 500
#define MAX_FANINOUT 500

/**********************************
other constants
*********************************/

#define ABS(x) (x>0 ? (x) : (-1*(x)))
#define INF 10000000  /** large number used as infinity */
#define NEARINF 10000 /*** large number but < INF **/
#define EPSILON 0.01  /* small number to terminate binary search in Phase A*/
#define MERGE_EPSILION 1000  /** uses in ASTRA to decide which FFs to merge; OBSELETE **/

/*** used for signal direction in Phase A constraint graph (S-graph) **/
#define FORWARD 0  
#define REVERSE 1

/*** used for bounds on r(v) in minarea */
#define UPPER 0
#define LOWER 1

/*** FF sharing model **/
#define MERGE 1
#define SINGLE 2


/**** for  constraint generation modes  *****/
#define SHENOY 1  /** use shenoy ICCAD94 algorithm */
#define REDUCE 2  /** use Minaret DAC 97 algorithm **/


/* constants for NODETYPE->type field, i.e, type of node */

#define Invalid 0
#define Pin 1
#define Pout 2
#define And	3
#define Or	4
#define Not   5
#define Nor 6
#define Nand 7
#define Latch	8	
#define Host 9
#define ARTIFICIAL 10

/**********************************
for hashing routines
*********************************/

#define PercentSplit 0.8    /* This is the percentage the table has to be full 
before it splits a node */
#define NodeNumMask 0x0000FFFF
#define PNperND 5     /* for some reason keep this small */
#define InitNDs 1024   /* Keep this one large.  The bigger the better but of course
you have to concider space requirements. Each of these is a structure*/


