/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/************************
check.c
NOT PART OF MAIN CODE
To identify and remove unreachable nodes.

************************/

#include<string.h>
#include<stdlib.h>
#include<time.h>

#include "include.h"
#include "main.h"

/*******************************
 EXTERNAL FUNCTIONS 
******************************/
void write_netlist(FILE *); /* or use write_benchmark now **/

int temp_counter=0;
FILE *yyin;

/*******************************
Need to run it twice, once for "dir 0" to remove gates 
unreachable from primary inputs, then for "dir 1" to remove
gates that do not fanout to primary outputs.

The program prompts for permission to write the output to a file,
this output will not contain any unreachable gates
******************************/

main(int argc,char **argv)
{

  FILE *fpin, *fpout;
  int i,n,n1;
  NODETYPE *np,*np1;
  Q *q1,*q2,*first;
  char   infile[100], outfile[100];
  int mode=0;
  int dir;

  if(argc != 3){
    printf(" \n usage tran <file name> dir \n");
    exit(0);
  }
  dir = atoi(argv[2]);
  printf(" Do u want to write a file give 1 if yes \n");
  scanf("%d",&mode);
  if(mode != 1)mode=0;
  strcpy(Ckt_Name,argv[1]); /* is global var **/
  strcpy(infile,"../../inp/");
  strcat(infile,argv[1]);
  strcpy(outfile,infile);
  strcat(outfile,".MY");
  strcat(infile,".bench");
  strcat(outfile,".bench");
  fpin = fopen(infile ,"r");
  if(fpin ==NULL) { 
    printf("cannot open file %s\n",infile);
    fflush(stdout); 
    exit(0); 
  }
  yyin =fpin;


  if(mode){  
    fpout  = fopen(outfile ,"w");
    if(fpout ==NULL) { 
      printf("cannot open file %s \n",outfile); 
      fflush(stdout); 
      exit(0); 
    }  
  }
  init_ckt_stuff(); /* imp initilizations */
  yyparse();

  top = bot = NULL;
  q1 = (Q *)CALLOC(1,sizeof(Q));


  for(i=0;i<nonodes;i++){
    if(validnode[i])nodes[i]->nai =0;
  }

  if(dir ==0){ 
    for(i =0;i<nopout;i++){
      n = primary_output[i];
      nodes[n]->nai = 1;
      addq(n);
    }
  }
  else {
    for(i =0;i<nopin;i++){ 
      n = primary_input[i];
      nodes[n]->nai = 1;
      addq(n);
    }
  }
  while(top !=NULL)
    {
      n = top->el;
      removeq();
      if(validnode[n])
	{ 
	  np = nodes[n];
	  if(dir ==0)first = np->fin;
	  else first = np->fout;

	  for(q1 = first;q1 != NULL;q1 = q1->next)
	    {
	      n1 = q1->el;
	      if(validnode[n1])
		{ 
		  np1 = nodes[n1];
		  if(np1->nai ==0){
		    np1->nai = 1;
		    addq(n1);/*printf("[%d]%s visit\t",n1,np1->name);*/
		  }
		}
	    }
	}

    }/* while top != NULL, Q not empty */

  for(i=0;i<nonodes;i++)
    {
      if(validnode[i])if(nodes[i]->nai != 1)
	{ /* DELETE THE NODE no need to delete it from fanin as fanin not printed*/
	  validnode[i] = 0;
	  np = nodes[i];
	  n = i;
	  printf(" deleteing node %d ie %s\n",n,np->name);
	  for(q1=np->fout;q1 != NULL; q1= q1->next){ 
	    nodes[q1->el]->fin = deleteq(nodes[q1->el]->fin,n);
	    nodes[q1->el]->nofin--;
	  }
	}
    }
  if(!mode)fpout = NULL;
  write_netlist(fpout);
}
